APPLE1	=1

ASCONE	='1'
INMASK	=$7F		; mask out the high bit for keyboard input

ESC	=$1B		; escape
SP	=$20		; space
CR	=$0D		; carriage return
LF	=$0A		; line feed

FROM	=$50		; move from MISCL,H
TO	=$52		; to MISCL2,H
SIZEL	=$54
SIZEH	=$55

STARTL	=$10
STARTH	=$11

	.if APPLE1
MOVE    =$F204
	.endif

	.org $A000
	.start MAIN

MAIN	
	CLD
	JSR SHOW	; show the menu
	JSR GETCH	; get the input
	JSR OUTCH
	CMP #ESC
	BEQ .STOP
	SEC
	SBC #ASCONE	; subtract ASCII '1' to get offfset
	CMP #NUM	; Are we in range?
	BCS .CONT	; Too large
	TAX		; X now holds offset for the selected item
	JSR CRLF
	JSR SELECT	; jump to the appropriate routine
.CONT	JMP MAIN	; loop forever
.STOP	RTS
	
SHOW	
	JSR CRLF
	LDX #$FF	; data
.NEXT	INX
	LDA MNUDAT,X
	BNE .NOTEOL
	JSR CRLF
	JMP .NEXT
.NOTEOL	CMP #$FF
	BEQ .DONE
	JSR OUTCH
	JMP .NEXT
.DONE	RTS
	
MMST	=$300
LMMST	=$300
HGST 	=$300
NIMST	=$300
PASST	=$300
CHST	=$1000
CAST	=$300

STARTSL
	.BYTE <MMST, <LMMST, <HGST, <NIMST, <PASST, <CHST, <CAST
STARTSH
	.BYTE >MMST, >LMMST, >HGST, >NIMST, >PASST, >CHST, >CAST

SELECT	
	LDA STARTSL,X
	STA STARTL
	LDA STARTSH,X
	STA STARTH
	LDA SRCL,X
	STA FROM
	LDA SRCH,X
	STA FROM+1
	LDA SZL,X
	STA SIZEL
	LDA SZH,X
	STA SIZEH
	LDA STARTL
	STA TO
	LDA STARTH
	STA TO+1
	JSR MOVE	
	JMP (STARTL)
  	
; ****************************************
; I/O routines
; ****************************************

CRLF			; Go to a new line.
	LDA #CR		; "CR"
	.if APPLE1
	JMP OUTCH
	.else
	JSR OUTCH
	LDA #LF		; "LF" - is this needed for the Apple 1?
	JMP OUTCH
	.endif
	RTS

GETCH   		; Get a character from the keyboard.
	LDA KBDRDY
	.if APPLE1
	BPL GETCH
	LDA KBD
	AND #INMASK
	.else
	BEQ GETCH
	.endif
	RTS
	
; Menu data

NUM	=$07		; Number of options in the menu
MNUDAT	.ascii	"CHOOSE A GAME"
	.byte	$00
	.ascii	"1. MASTERMIND"
	.byte	$00
	.ascii	"2. LITTLE MASTERMIND"
	.byte	$00
	.ascii	"3. 100 GAME"
	.byte	$00
	.ascii	"4. NIM"	
	.byte	$00
	.ascii	"5. PASART"	
	.byte	$00
	.ascii	"6. MICROCHESS"	
	.byte	$00
	.ascii	"7. 1D CA"	
	.byte	$00
	.ascii	"> "
	.byte	$FF

MM
	.BYTE $A2, $08, $BD, $95, $03, $20, $EF, $FF, $CA, $D0, $F7, $86, $E2, $E6, $E3, $D0
	.BYTE $02, $E6, $E4, $AD, $11, $D0, $10, $F5, $20, $AC, $03, $38, $F8, $8A, $65, $E2
	.BYTE $85, $E2, $D8, $20, $A7, $03, $A5, $E2, $20, $DC, $FF, $A9, $A0, $A8, $20, $EF
	.BYTE $FF, $A5, $E3, $85, $E5, $A5, $E4, $A2, $05, $94, $E5, $A0, $03, $4A, $26, $E5
	.BYTE $36, $E5, $88, $D0, $F8, $CA, $D0, $F1, $20, $AC, $03, $C9, $9B, $F0, $65, $20
	.BYTE $EF, $FF, $49, $B0, $C9, $08, $B0, $CB, $95, $EF, $CA, $E0, $FB, $D0, $E9, $A0
	.BYTE $FB, $A9, $A0, $20, $EF, $FF, $B5, $F0, $D5, $EB, $D0, $0D, $94, $EB, $A9, $AB
	.BYTE $95, $F0, $C8, $D0, $EE, $A2, $11, $D0, $89, $E8, $D0, $EA, $A0, $FB, $B6, $F0
	.BYTE $8A, $A2, $FB, $D5, $EB, $D0, $07, $94, $EB, $A9, $AD, $20, $EF, $FF, $E8, $D0
	.BYTE $F2, $C8, $D0, $EA, $F0, $85, $BF, $D9, $C4, $C1, $C5, $D2, $8D, $8D, $CE, $C9
	.BYTE $D7, $A0, $D5, $CF, $D9, $A0, $AB, $A9, $8D, $4C, $EF, $FF, $AD, $11, $D0, $10
	.BYTE $FB, $AD, $10, $D0, $60
LMM	
	.BYTE $A2, $08, $BD, $98, $03, $20, $EF, $FF, $CA, $D0, $F7, $86, $E2, $E6, $E3, $D0
	.BYTE $02, $E6, $E4, $AD, $11, $D0, $10, $F5, $20, $AF, $03, $38, $F8, $8A, $65, $E2
	.BYTE $85, $E2, $D8, $20, $AA, $03, $A5, $E2, $20, $DC, $FF, $A9, $A0, $A8, $20, $EF
	.BYTE $FF, $A5, $E3, $85, $E5, $A5, $E4, $A2, $03, $94, $E5, $A0, $03, $4A, $26, $E5
	.BYTE $36, $E5, $88, $D0, $F8, $CA, $D0, $F1, $20, $B8, $03, $20, $AF, $03, $C9, $9B
	.BYTE $F0, $65, $20, $EF, $FF, $49, $B0, $C9, $05, $B0, $C8, $95, $ED, $CA, $E0, $FD
	.BYTE $D0, $E9, $A0, $FD, $A9, $A0, $20, $EF, $FF, $B5, $EE, $D5, $E9, $D0, $0D, $94
	.BYTE $E9, $A9, $AB, $95, $EE, $C8, $D0, $EE, $A2, $11, $D0, $86, $E8, $D0, $EA, $A0
	.BYTE $FD, $B6, $EE, $8A, $A2, $FD, $D5, $E9, $D0, $07, $94, $E9, $A9, $AD, $20, $EF
	.BYTE $FF, $E8, $D0, $F2, $C8, $D0, $EA, $F0, $82, $BF, $D9, $C4, $C1, $C5, $D2, $8D
	.BYTE $8D, $CE, $C9, $D7, $A0, $D5, $CF, $D9, $A0, $AB, $A9, $8D, $4C, $EF, $FF, $AD
	.BYTE $11, $D0, $10, $FB, $AD, $10, $D0, $60, $A2, $03, $B5, $E5, $29, $07, $C9, $05
	.BYTE $30, $03, $4A, $95, $E5, $CA, $D0, $F2, $60
HG
	.BYTE $F8, $20, $F8, $03, $4C, $2E, $03, $49, $4E, $56, $41, $4C, $49, $44, $00, $59
	.BYTE $4F, $55, $00, $57, $49, $4E, $21, $00, $4C, $4F, $53, $45, $21, $00, $49, $20
	.BYTE $50, $4C, $41, $59, $20, $00, $53, $55, $4D, $20, $49, $53, $20, $00, $E6, $07
	.BYTE $20, $8C, $04, $A5, $05, $20, $A7, $03, $A5, $07, $6A, $90, $05, $20, $11, $04
	.BYTE $D0, $03, $20, $3F, $04, $18, $65, $05, $B0, $04, $85, $05, $D0, $E0, $48, $48
	.BYTE $20, $A2, $03, $20, $8C, $04, $A9, $01, $20, $E5, $FF, $68, $20, $DC, $FF, $20
	.BYTE $A2, $03, $20, $A2, $03, $20, $97, $04, $20, $9D, $03, $68, $F0, $0B, $A9, $18
	.BYTE $85, $03, $A9, $03, $85, $04, $38, $B0, $08, $A9, $13, $85, $03, $A9, $03, $85
	.BYTE $04, $20, $B6, $03, $20, $A2, $03, $20, $A2, $03, $4C, $00, $03, $AD, $11, $D0
	.BYTE $10, $FB, $AD, $10, $D0, $29, $7F, $60, $A9, $2D, $20, $EF, $FF, $A9, $20, $4C
	.BYTE $EF, $FF, $A9, $0D, $4C, $EF, $FF, $C9, $10, $90, $05, $20, $DC, $FF, $D0, $03
	.BYTE $20, $E5, $FF, $4C, $A2, $03, $A0, $00, $B1, $03, $F0, $06, $20, $EF, $FF, $C8
	.BYTE $D0, $F6, $60, $49, $30, $C9, $0A, $90, $08, $69, $88, $C9, $FA, $90, $03, $29
	.BYTE $0F, $60, $A9, $FF, $60, $B5, $00, $20, $C3, $03, $C9, $FF, $F0, $17, $48, $E8
	.BYTE $B5, $00, $20, $C3, $03, $C9, $FF, $D0, $02, $68, $60, $85, $02, $68, $0A, $0A
	.BYTE $0A, $0A, $65, $02, $60, $A9, $FF, $60, $A9, $00, $85, $07, $C6, $07, $85, $05
	.BYTE $85, $06, $E6, $06, $60, $A9, $1E, $85, $03, $A9, $03, $85, $04, $20, $B6, $03
	.BYTE $60, $A5, $05, $C5, $06, $F0, $0C, $30, $16, $A9, $11, $18, $65, $06, $85, $06
	.BYTE $4C, $11, $04, $A5, $05, $65, $06, $29, $0F, $D0, $09, $A9, $05, $D0, $05, $A5
	.BYTE $06, $38, $E5, $05, $48, $48, $20, $05, $04, $68, $20, $A7, $03, $68, $60, $20
	.BYTE $98, $03, $A2, $00, $86, $00, $86, $01, $20, $8D, $03, $C9, $1B, $F0, $3A, $C9
	.BYTE $0D, $F0, $12, $C9, $30, $30, $F1, $C9, $3A, $10, $ED, $95, $00, $20, $EF, $FF
	.BYTE $E8, $E0, $02, $D0, $E3, $20, $A2, $03, $A2, $00, $20, $D5, $03, $F0, $09, $C9
	.BYTE $FF, $F0, $05, $C9, $11, $B0, $01, $60, $A9, $07, $85, $03, $A9, $03, $85, $04
	.BYTE $20, $B6, $03, $20, $A2, $03, $4C, $3F, $04, $68, $68, $60, $A9, $26, $85, $03
	.BYTE $A9, $03, $85, $04, $4C, $B6, $03, $A5, $07, $6A, $90, $05, $A9, $49, $4C, $EF
	.BYTE $FF, $A9, $0F, $85, $03, $A9, $03, $85, $04, $20, $B6, $03, $60
NIM
	.BYTE $20, $DB, $03, $4C, $2E, $03, $49, $4E, $56, $41, $4C, $49, $44, $00, $59, $4F
	.BYTE $55, $00, $57, $49, $4E, $21, $00, $49, $20, $54, $41, $4B, $45, $00, $46, $52
	.BYTE $4F, $4D, $20, $48, $45, $41, $50, $00, $53, $20, $41, $52, $45, $00, $E6, $13
	.BYTE $20, $C8, $04, $A5, $13, $6A, $90, $06, $20, $56, $04, $38, $B0, $03, $20, $8D
	.BYTE $04, $20, $8F, $03, $A6, $14, $B5, $14, $D0, $E4, $CA, $D0, $F9, $20, $C8, $04
	.BYTE $20, $8F, $03, $20, $E9, $04, $20, $8A, $03, $A9, $12, $85, $11, $A9, $03, $85
	.BYTE $12, $20, $94, $03, $20, $8F, $03, $20, $8F, $03, $4C, $00, $03, $AD, $11, $D0
	.BYTE $10, $FB, $AD, $10, $D0, $29, $7F, $C9, $1B, $D0, $07, $68, $68, $68, $68, $68
	.BYTE $68, $60, $4C, $EF, $FF, $A9, $3F, $20, $EF, $FF, $A9, $20, $4C, $EF, $FF, $A9
	.BYTE $0D, $4C, $EF, $FF, $A0, $00, $B1, $11, $F0, $06, $20, $EF, $FF, $C8, $D0, $F6
	.BYTE $60, $49, $30, $C9, $0A, $90, $08, $69, $88, $C9, $FA, $90, $03, $29, $0F, $60
	.BYTE $A9, $FF, $60, $20, $8F, $03, $A9, $06, $85, $11, $A9, $03, $85, $12, $20, $94
	.BYTE $03, $4C, $8F, $03, $A9, $23, $85, $11, $A9, $03, $85, $12, $4C, $94, $03, $20
	.BYTE $94, $03, $20, $85, $03, $20, $6D, $03, $4C, $A1, $03, $A9, $00, $85, $13, $C6
	.BYTE $13, $20, $8F, $03, $20, $C4, $03, $A9, $53, $20, $EF, $FF, $20, $D2, $03, $AA
	.BYTE $F0, $28, $C9, $FF, $F0, $24, $86, $14, $A0, $31, $A2, $00, $20, $8F, $03, $98
	.BYTE $20, $EF, $FF, $20, $D2, $03, $C9, $00, $F0, $16, $C9, $FF, $F0, $12, $95, $15
	.BYTE $C8, $E8, $E4, $14, $D0, $E6, $20, $8F, $03, $60, $20, $B3, $03, $4C, $E1, $03
	.BYTE $20, $B3, $03, $4C, $F8, $03, $A6, $14, $A9, $00, $55, $14, $CA, $D0, $FB, $85
	.BYTE $10, $C9, $00, $F0, $15, $A6, $14, $A5, $10, $55, $14, $D5, $14, $30, $03, $CA
	.BYTE $D0, $F5, $85, $10, $B5, $14, $38, $E5, $10, $60, $A6, $14, $B5, $15, $D0, $03
	.BYTE $CA, $D0, $F9, $A9, $01, $60, $A9, $17, $85, $11, $A9, $03, $85, $12, $20, $94
	.BYTE $03, $20, $8A, $03, $20, $26, $04, $85, $10, $20, $E5, $FF, $20, $8A, $03, $A9
	.BYTE $1E, $85, $11, $A9, $03, $85, $12, $20, $94, $03, $20, $8A, $03, $8A, $20, $E5
	.BYTE $FF, $CA, $B5, $15, $38, $E5, $10, $95, $15, $20, $8F, $03, $60, $20, $C4, $03
	.BYTE $20, $D2, $03, $AA, $F0, $2C, $E0, $FF, $F0, $28, $E4, $14, $F0, $02, $B0, $22
	.BYTE $CA, $20, $8F, $03, $A9, $19, $85, $11, $A9, $03, $85, $12, $20, $CF, $03, $C9
	.BYTE $00, $F0, $0F, $C9, $FF, $F0, $0B, $D5, $15, $F0, $02, $B0, $05, $85, $10, $4C
	.BYTE $82, $04, $20, $B3, $03, $4C, $8D, $04, $20, $C4, $03, $A9, $28, $85, $11, $A9
	.BYTE $03, $85, $12, $20, $94, $03, $A2, $00, $20, $8A, $03, $B5, $15, $20, $E5, $FF
	.BYTE $E8, $E4, $14, $30, $F3, $20, $8F, $03, $60, $A5, $13, $6A, $90, $05, $A9, $49
	.BYTE $4C, $EF, $FF, $A9, $0E, $85, $11, $A9, $03, $85, $12, $20, $94, $03, $60
PAS
	.BYTE $20, $3A, $05, $A9, $20, $85, $10, $A9, $00, $85, $00, $A9, $10, $85, $01, $20
	.BYTE $47, $03, $20, $F0, $03, $20, $9E, $04, $20, $3F, $05, $C9, $1B, $D0, $E1, $60
	.BYTE $20, $3F, $53, $57, $4F, $52, $20, $3F, $53, $4E, $4D, $55, $4C, $4F, $43, $20
	.BYTE $3F, $53, $4C, $4F, $42, $4D, $59, $53, $20, $3F, $29, $33, $2C, $32, $2C, $31
	.BYTE $28, $20, $45, $4C, $59, $54, $53, $A2, $06, $BD, $1F, $03, $20, $EF, $FF, $CA
	.BYTE $D0, $F7, $A5, $02, $20, $C4, $03, $C9, $03, $30, $EC, $85, $02, $85, $0B, $A2
	.BYTE $09, $BD, $25, $03, $20, $EF, $FF, $CA, $D0, $F7, $A5, $03, $20, $C4, $03, $C9
	.BYTE $03, $30, $EC, $C9, $28, $10, $E8, $85, $03, $85, $0C, $A2, $09, $BD, $2E, $03
	.BYTE $20, $EF, $FF, $CA, $D0, $F7, $20, $3F, $05, $C9, $1B, $D0, $03, $68, $68, $60
	.BYTE $C9, $0D, $F0, $0A, $48, $20, $EF, $FF, $68, $E8, $95, $10, $D0, $E8, $8A, $F0
	.BYTE $03, $E8, $86, $05, $20, $3A, $05, $A2, $0F, $BD, $37, $03, $20, $EF, $FF, $CA
	.BYTE $D0, $F7, $E6, $04, $A5, $04, $20, $C4, $03, $F0, $EC, $C9, $04, $10, $E8, $85
	.BYTE $04, $C6, $04, $60, $85, $0D, $A2, $00, $86, $06, $86, $07, $86, $08, $20, $3F
	.BYTE $05, $C9, $1B, $D0, $05, $68, $68, $68, $68, $60, $20, $EF, $FF, $C9, $0D, $F0
	.BYTE $05, $95, $06, $E8, $D0, $E8, $8A, $F0, $04, $20, $0E, $05, $60, $A5, $0D, $60
	.BYTE $A2, $01, $A5, $04, $F0, $16, $C9, $01, $D0, $04, $C6, $0B, $D0, $0E, $A5, $02
	.BYTE $4A, $69, $00, $85, $0B, $A5, $03, $4A, $69, $00, $85, $0C, $A0, $01, $A9, $00
	.BYTE $86, $09, $84, $0A, $CA, $20, $BD, $04, $85, $08, $E8, $88, $20, $BD, $04, $C8
	.BYTE $18, $65, $08, $20, $7F, $04, $48, $20, $E8, $04, $68, $A2, $00, $81, $06, $A6
	.BYTE $04, $F0, $3D, $CA, $F0, $22, $48, $A6, $09, $20, $94, $04, $20, $E8, $04, $68
	.BYTE $48, $A2, $00, $81, $06, $A6, $09, $A4, $0A, $20, $8A, $04, $20, $E8, $04, $68
	.BYTE $48, $A2, $00, $81, $06, $38, $B0, $08, $48, $A5, $03, $38, $E5, $09, $85, $0C
	.BYTE $A6, $09, $20, $8A, $04, $20, $94, $04, $20, $E8, $04, $68, $A2, $00, $81, $06
	.BYTE $A6, $09, $A4, $0A, $C8, $C4, $0C, $D0, $95, $E8, $E4, $0B, $D0, $8E, $60, $38
	.BYTE $E5, $05, $F0, $05, $10, $F9, $18, $65, $05, $60, $48, $A5, $02, $38, $E5, $09
	.BYTE $AA, $CA, $68, $60, $48, $A5, $03, $38, $E5, $0A, $A8, $88, $68, $60, $A2, $00
	.BYTE $A0, $00, $20, $3A, $05, $20, $BD, $04, $86, $09, $AA, $B5, $10, $A6, $09, $20
	.BYTE $EF, $FF, $C8, $C4, $03, $D0, $EE, $E8, $E4, $02, $D0, $E4, $60, $8A, $F0, $25
	.BYTE $98, $F0, $22, $A5, $04, $F0, $10, $8A, $38, $E5, $02, $C9, $FF, $F0, $16, $98
	.BYTE $38, $E5, $03, $C9, $FF, $F0, $0E, $20, $E8, $04, $86, $0D, $A2, $00, $A1, $06
	.BYTE $A6, $0D, $18, $90, $02, $A9, $01, $60, $8A, $48, $A5, $01, $85, $07, $A5, $00
	.BYTE $85, $06, $E0, $00, $F0, $0C, $18, $65, $03, $85, $06, $90, $02, $E6, $07, $CA
	.BYTE $D0, $F5, $98, $65, $06, $85, $06, $90, $02, $E6, $07, $68, $AA, $60, $A5, $06
	.BYTE $20, $31, $05, $C9, $FF, $F0, $20, $48, $A5, $07, $20, $31, $05, $C9, $FF, $D0
	.BYTE $02, $68, $60, $85, $0D, $68, $85, $08, $0A, $0A, $18, $65, $08, $0A, $65, $0D
	.BYTE $60, $49, $30, $C9, $0A, $90, $02, $A9, $FF, $60, $A9, $0D, $4C, $EF, $FF, $AD
	.BYTE $11, $D0, $10, $FB, $AD, $10, $D0, $29, $7F, $60
MCHESS
	.BYTE $20, $BC, $15, $20, $F8, $16, $20, $7D, $10, $A5, $4E, $29, $01, $F0, $02, $D0
	.BYTE $26, $A9, $CC, $85, $49, $D8, $A2, $FF, $9A, $A2, $C8, $86, $B2, $20, $12, $15
	.BYTE $A9, $2D, $85, $2D, $20, $EF, $14, $20, $F8, $18, $C9, $43, $D0, $05, $20, $7D
	.BYTE $10, $D0, $22, $C9, $45, $D0, $0D, $20, $17, $13, $A5, $4D, $49, $01, $85, $4D
	.BYTE $A9, $EE, $D0, $11, $C9, $44, $D0, $03, $4C, $15, $10, $C9, $50, $D0, $0E, $20
	.BYTE $F3, $18, $20, $2A, $14, $85, $4B, $85, $4A, $85, $49, $D0, $B8, $C9, $0D, $D0
	.BYTE $0E, $A5, $49, $20, $D0, $15, $20, $B1, $13, $20, $50, $12, $4C, $15, $10, $C9
	.BYTE $51, $F0, $07, $C9, $1B, $F0, $03, $4C, $40, $12, $4C, $00, $A0, $A2, $1F, $BD
	.BYTE $AD, $18, $95, $50, $CA, $10, $F8, $A9, $00, $85, $4D, $A2, $1B, $86, $DC, $A9
	.BYTE $CC, $60, $99, $22, $06, $45, $32, $0C, $72, $14, $01, $63, $63, $05, $64, $43
	.BYTE $0F, $63, $41, $05, $52, $25, $07, $44, $34, $0E, $53, $33, $0F, $CC, $99, $22
	.BYTE $07, $55, $32, $0D, $45, $06, $00, $63, $14, $01, $14, $13, $06, $34, $14, $04
	.BYTE $36, $25, $06, $52, $33, $0E, $43, $24, $0F, $44, $99, $25, $0B, $25, $01, $00
	.BYTE $33, $25, $07, $36, $34, $0D, $34, $34, $0E, $52, $25, $0D, $45, $35, $04, $55
	.BYTE $22, $06, $43, $33, $0F, $CC, $99, $52, $04, $52, $52, $06, $75, $44, $06, $52
	.BYTE $41, $04, $43, $43, $0F, $43, $25, $06, $52, $32, $04, $42, $22, $07, $55, $34
	.BYTE $0F, $44, $99, $25, $07, $66, $43, $0E, $55, $55, $04, $54, $13, $01, $63, $34
	.BYTE $0E, $33, $01, $00, $52, $46, $04, $55, $22, $06, $43, $33, $0F, $CC, $99, $06
	.BYTE $00, $52, $11, $06, $34, $22, $0B, $22, $23, $06, $64, $14, $04, $43, $44, $06
	.BYTE $75, $25, $06, $31, $22, $07, $55, $34, $0F, $44, $99, $25, $01, $25, $15, $01
	.BYTE $33, $25, $07, $72, $01, $00, $63, $11, $04, $66, $21, $0A, $56, $22, $06, $53
	.BYTE $35, $0D, $52, $34, $0E, $CC, $99, $35, $0C, $52, $52, $06, $62, $44, $06, $52
	.BYTE $06, $00, $75, $14, $04, $66, $11, $05, $56, $21, $0B, $55, $24, $0F, $42, $25
	.BYTE $06, $43, $99, $03, $02, $63, $25, $0B, $25, $41, $05, $54, $24, $0E, $72, $01
	.BYTE $00, $36, $46, $04, $52, $25, $07, $55, $22, $06, $43, $33, $0F, $CC, $99, $03
	.BYTE $07, $74, $14, $01, $52, $52, $04, $36, $23, $0E, $53, $06, $00, $75, $41, $04
	.BYTE $31, $25, $06, $52, $22, $07, $55, $34, $0F, $44, $A6, $B5, $30, $5C, $A5, $B0
	.BYTE $F0, $08, $E0, $08, $D0, $04, $C5, $E6, $F0, $2E, $F6, $E3, $C9, $01, $D0, $02
	.BYTE $F6, $E3, $50, $1E, $A0, $0F, $A5, $B1, $D9, $60, $00, $F0, $03, $88, $10, $F8
	.BYTE $B9, $DE, $18, $D5, $E4, $90, $04, $94, $E6, $95, $E4, $18, $08, $75, $E5, $95
	.BYTE $E5, $28, $E0, $04, $F0, $03, $30, $31, $60, $A5, $E8, $85, $DD, $A9, $00, $85
	.BYTE $B5, $20, $B1, $13, $20, $17, $13, $20, $65, $12, $20, $17, $13, $A9, $08, $85
	.BYTE $B5, $20, $6E, $12, $20, $97, $13, $4C, $89, $14, $E0, $F9, $D0, $0B, $A5, $60
	.BYTE $C5, $B1, $D0, $04, $A9, $00, $85, $B4, $60, $50, $FD, $A0, $07, $A5, $B1, $D9
	.BYTE $60, $00, $F0, $05, $88, $F0, $F1, $10, $F6, $B9, $DE, $18, $D5, $E2, $90, $02
	.BYTE $95, $E2, $C6, $B5, $A9, $FB, $C5, $B5, $F0, $03, $20, $8B, $13, $E6, $B5, $60
	.BYTE $38, $E9, $30, $C9, $08, $B0, $06, $20, $79, $14, $20, $53, $12, $4C, $24, $10
	.BYTE $A5, $49, $2C, $A5, $4A, $A2, $1F, $D5, $50, $F0, $05, $CA, $10, $F9, $A2, $BB
	.BYTE $86, $4B, $86, $B0, $60, $A2, $10, $A9, $00, $95, $DE, $CA, $10, $FB, $A9, $10
	.BYTE $85, $B0, $C6, $B0, $10, $01, $60, $20, $84, $13, $A4, $B0, $A2, $08, $86, $B6
	.BYTE $C0, $08, $10, $41, $C0, $06, $10, $2E, $C0, $04, $10, $1F, $C0, $01, $F0, $09
	.BYTE $10, $0E, $20, $F3, $12, $D0, $FB, $F0, $D9, $20, $01, $13, $D0, $FB, $F0, $D2
	.BYTE $A2, $04, $86, $B6, $20, $01, $13, $D0, $FB, $F0, $C7, $20, $01, $13, $A5, $B6
	.BYTE $C9, $04, $D0, $F7, $F0, $BC, $A2, $10, $86, $B6, $20, $F3, $12, $A5, $B6, $C9
	.BYTE $08, $D0, $F7, $F0, $AD, $A2, $06, $86, $B6, $20, $2F, $13, $50, $05, $30, $03
	.BYTE $20, $AA, $11, $20, $84, $13, $C6, $B6, $A5, $B6, $C9, $05, $F0, $EB, $20, $2F
	.BYTE $13, $70, $8F, $30, $8D, $20, $AA, $11, $A5, $B1, $29, $F0, $C9, $20, $F0, $EE
	.BYTE $4C, $72, $12, $20, $2F, $13, $30, $03, $20, $AA, $11, $20, $84, $13, $C6, $B6
	.BYTE $60, $20, $2F, $13, $90, $02, $50, $F9, $30, $07, $08, $20, $AA, $11, $28, $50
	.BYTE $F0, $20, $84, $13, $C6, $B6, $60, $A2, $0F, $38, $B4, $60, $A9, $77, $F5, $50
	.BYTE $95, $60, $94, $50, $38, $A9, $77, $F5, $50, $95, $50, $CA, $10, $EB, $60, $A5
	.BYTE $B1, $A6, $B6, $18, $7D, $CD, $18, $85, $B1, $29, $88, $D0, $42, $A5, $B1, $A2
	.BYTE $20, $CA, $30, $0E, $D5, $50, $D0, $F9, $E0, $10, $30, $33, $A9, $7F, $69, $01
	.BYTE $70, $01, $B8, $A5, $B5, $30, $24, $C9, $00, $10, $20, $48, $08, $A9, $F9, $85
	.BYTE $B5, $85, $B4, $20, $B1, $13, $20, $17, $13, $20, $6E, $12, $20, $94, $13, $28
	.BYTE $68, $85, $B5, $A5, $B4, $30, $04, $38, $A9, $FF, $60, $18, $A9, $00, $60, $A9
	.BYTE $FF, $18, $B8, $60, $A6, $B0, $B5, $50, $85, $B1, $60, $20, $B1, $13, $20, $17
	.BYTE $13, $20, $6E, $12, $20, $17, $13, $BA, $86, $B3, $A6, $B2, $9A, $68, $85, $B6
	.BYTE $68, $85, $B0, $AA, $68, $95, $50, $68, $AA, $68, $85, $B1, $95, $50, $4C, $D6
	.BYTE $13, $BA, $86, $B3, $A6, $B2, $9A, $A5, $B1, $48, $A8, $A2, $1F, $D5, $50, $F0
	.BYTE $03, $CA, $10, $F9, $A9, $CC, $95, $50, $8A, $48, $A6, $B0, $B5, $50, $94, $50
	.BYTE $48, $8A, $48, $A5, $B6, $48, $BA, $86, $B2, $A6, $B3, $9A, $60, $A4, $E4, $EC
	.BYTE $DE, $18, $D0, $04, $A9, $00, $F0, $0A, $A6, $E3, $D0, $06, $A6, $EE, $D0, $02
	.BYTE $A9, $FF, $A2, $04, $86, $B5, $C5, $4A, $90, $0C, $F0, $0A, $85, $4A, $A5, $B0
	.BYTE $85, $4B, $A5, $B1, $85, $49, $A5, $2D, $49, $1F, $85, $2D, $4C, $0D, $15, $A4
	.BYTE $DC, $A5, $49, $D1, $43, $60, $A0, $0A, $88, $98, $48, $20, $4A, $17, $20, $0F
	.BYTE $14, $F0, $07, $68, $A8, $88, $D0, $F0, $F0, $18, $A4, $DC, $30, $18, $20, $0F
	.BYTE $14, $D0, $E3, $88, $B1, $43, $85, $4B, $88, $B1, $43, $85, $49, $88, $84, $DC
	.BYTE $D0, $1C, $A9, $FF, $85, $DC, $A2, $0C, $86, $B5, $86, $4A, $A2, $14, $20, $67
	.BYTE $12, $A2, $04, $86, $B5, $20, $65, $12, $A6, $4A, $E0, $0F, $90, $18, $A6, $4B
	.BYTE $B5, $50, $85, $4A, $86, $B0, $A5, $49, $85, $B1, $20, $D0, $15, $20, $B1, $13
	.BYTE $20, $50, $12, $4C, $15, $10, $A9, $FF, $60, $A2, $04, $06, $49, $26, $4A, $CA
	.BYTE $D0, $F9, $05, $49, $85, $49, $85, $B1, $60, $18, $A9, $80, $65, $EB, $65, $EC
	.BYTE $65, $ED, $65, $E1, $65, $DF, $38, $E5, $F0, $E5, $F1, $E5, $E2, $E5, $E0, $E5
	.BYTE $DE, $E5, $EF, $E5, $E3, $B0, $02, $A9, $00, $4A, $18, $69, $40, $65, $EC, $65
	.BYTE $ED, $38, $E5, $E4, $4A, $18, $69, $90, $65, $DD, $65, $DD, $65, $DD, $65, $DD
	.BYTE $65, $E1, $38, $E5, $E4, $E5, $E4, $E5, $E5, $E5, $E5, $E5, $E0, $A6, $B1, $E0
	.BYTE $33, $F0, $16, $E0, $34, $F0, $12, $E0, $22, $F0, $0E, $E0, $25, $F0, $0A, $A6
	.BYTE $B0, $F0, $09, $B4, $50, $C0, $10, $10, $03, $18, $69, $02, $4C, $DD, $13, $20
	.BYTE $F3, $18, $A5, $2D, $20, $EF, $FF, $20, $EE, $18, $20, $F4, $15, $20, $EE, $18
	.BYTE $A5, $4A, $20, $CB, $15, $20, $EE, $18, $A5, $49, $4C, $CB, $15, $A9, $2E, $4C
	.BYTE $EF, $FF, $20, $F3, $18, $20, $A5, $15, $20, $80, $15, $A0, $00, $20, $CA, $15
	.BYTE $A9, $21, $20, $EF, $FF, $A2, $1F, $98, $D5, $50, $F0, $35, $CA, $10, $F9, $98
	.BYTE $0A, $0A, $0A, $0A, $98, $69, $00, $4A, $A9, $20, $90, $02, $A9, $23, $20, $EF
	.BYTE $FF, $20, $EF, $FF, $C8, $98, $29, $08, $F0, $D6, $A9, $21, $20, $EF, $FF, $20
	.BYTE $CA, $15, $20, $F3, $18, $20, $80, $15, $98, $18, $69, $08, $30, $47, $A8, $10
	.BYTE $BC, $A9, $57, $E0, $10, $24, $4D, $F0, $04, $2A, $49, $01, $6A, $90, $02, $A9
	.BYTE $42, $20, $EF, $FF, $8A, $29, $0F, $AA, $BD, $9D, $18, $20, $EF, $FF, $D0, $C4
	.BYTE $20, $EE, $18, $20, $EE, $18, $8A, $48, $A2, $08, $A9, $2B, $20, $EF, $FF, $A9
	.BYTE $2D, $20, $EF, $FF, $20, $EF, $FF, $CA, $D0, $F0, $A9, $2B, $20, $EF, $FF, $68
	.BYTE $AA, $20, $F3, $18, $60, $20, $EE, $18, $20, $EF, $FF, $A2, $00, $20, $EE, $18
	.BYTE $8A, $20, $DC, $FF, $E8, $E0, $08, $D0, $F4, $4C, $F3, $18, $A2, $00, $BD, $24
	.BYTE $18, $30, $06, $20, $EF, $FF, $E8, $D0, $F5, $60, $98, $29, $77, $4C, $DC, $FF
	.BYTE $A2, $1F, $D5, $50, $F0, $04, $CA, $10, $F9, $60, $48, $A5, $4B, $48, $8A, $85
	.BYTE $4B, $20, $F3, $18, $A2, $9C, $20, $FE, $15, $20, $EE, $18, $20, $F4, $15, $68
	.BYTE $85, $4B, $68, $60, $A5, $4B, $30, $13, $29, $0F, $0A, $0A, $0A, $AA, $A0, $08
	.BYTE $BD, $80, $17, $20, $EF, $FF, $E8, $88, $D0, $F6, $60, $C9, $CC, $D0, $04, $A2
	.BYTE $80, $D0, $EB, $C9, $EE, $D0, $04, $A2, $88, $D0, $E3, $C9, $FF, $D0, $04, $A2
	.BYTE $90, $D0, $DB, $A2, $94, $D0, $D7, $53, $45, $4C, $45, $43, $54, $20, $4C, $45
	.BYTE $56, $45, $4C, $3A, $00, $00, $30, $29, $20, $53, $55, $50, $45, $52, $42, $4C
	.BYTE $49, $54, $5A, $00, $31, $29, $20, $42, $4C, $49, $54, $5A, $00, $32, $29, $20
	.BYTE $4E, $4F, $52, $4D, $41, $4C, $00, $FF, $00, $53, $45, $4C, $45, $43, $54, $20
	.BYTE $4F, $50, $45, $4E, $49, $4E, $47, $3A, $20, $43, $4F, $4D, $50, $20, $50, $4C
	.BYTE $41, $59, $53, $00, $00, $46, $52, $45, $4E, $43, $48, $20, $44, $45, $46, $45
	.BYTE $4E, $43, $45, $3A, $20, $30, $29, $20, $57, $20, $31, $29, $20, $42, $00, $47
	.BYTE $49, $55, $4F, $43, $4F, $20, $50, $49, $41, $4E, $4F, $3A, $20, $20, $20, $32
	.BYTE $29, $20, $57, $20, $33, $29, $20, $42, $00, $52, $55, $59, $20, $4C, $4F, $50
	.BYTE $45, $5A, $3A, $20, $20, $20, $20, $20, $20, $34, $29, $20, $57, $20, $35, $29
	.BYTE $20, $42, $00, $51, $55, $45, $45, $4E, $27, $53, $20, $49, $4E, $44, $49, $41
	.BYTE $4E, $3A, $20, $36, $29, $20, $57, $20, $37, $29, $20, $42, $00, $46, $4F, $55
	.BYTE $52, $20, $4B, $4E, $49, $47, $48, $54, $53, $3A, $20, $20, $20, $38, $29, $20
	.BYTE $57, $20, $39, $29, $20, $42, $00, $FF, $A9, $27, $85, $41, $A9, $16, $85, $42
	.BYTE $20, $63, $17, $20, $F8, $18, $20, $EF, $FF, $38, $E9, $30, $AA, $D0, $09, $8E
	.BYTE $58, $13, $CA, $8E, $35, $12, $D0, $1A, $CA, $D0, $0A, $8E, $58, $13, $A2, $FB
	.BYTE $8E, $35, $12, $D0, $0D, $CA, $D0, $D0, $A2, $08, $8E, $58, $13, $A2, $FB, $8E
	.BYTE $35, $12, $A9, $58, $85, $41, $A9, $16, $85, $42, $20, $63, $17, $20, $F8, $18
	.BYTE $20, $EF, $FF, $38, $E9, $30, $C5, $40, $B0, $E8, $85, $4E, $AA, $E8, $A9, $10
	.BYTE $85, $44, $A9, $92, $CA, $F0, $09, $18, $69, $1C, $90, $F8, $E6, $44, $D0, $F4
	.BYTE $85, $43, $60, $20, $F3, $18, $A0, $FF, $C8, $B1, $41, $D0, $06, $20, $F3, $18
	.BYTE $4C, $68, $17, $C9, $FF, $F0, $06, $20, $EF, $FF, $4C, $68, $17, $84, $40, $60
	.BYTE $4B, $49, $4E, $47, $20, $20, $20, $20, $51, $55, $45, $45, $4E, $20, $20, $20
	.BYTE $4B, $20, $52, $4F, $4F, $4B, $20, $20, $51, $20, $52, $4F, $4F, $4B, $20, $20
	.BYTE $4B, $20, $42, $49, $53, $48, $4F, $50, $51, $20, $42, $49, $53, $48, $4F, $50
	.BYTE $4B, $20, $4B, $4E, $49, $47, $48, $54, $51, $20, $4B, $4E, $49, $47, $48, $54
	.BYTE $4B, $20, $52, $20, $50, $41, $57, $4E, $51, $20, $52, $20, $50, $41, $57, $4E
	.BYTE $4B, $20, $4E, $20, $50, $41, $57, $4E, $51, $20, $4E, $20, $50, $41, $57, $4E
	.BYTE $4B, $20, $42, $20, $50, $41, $57, $4E, $51, $20, $42, $20, $50, $41, $57, $4E
	.BYTE $51, $20, $50, $41, $57, $4E, $20, $20, $4B, $20, $50, $41, $57, $4E, $20, $20
	.BYTE $52, $45, $53, $45, $54, $20, $20, $20, $45, $58, $43, $48, $41, $4E, $47, $45
	.BYTE $4D, $41, $54, $45, $20, $20, $20, $20, $20, $20, $20, $20, $43, $41, $50, $54
	.BYTE $55, $52, $45, $53, $0D, $2B, $2D, $2D, $2D, $2D, $2D, $2D, $2D, $2D, $2D, $2D
	.BYTE $2D, $2D, $2D, $2D, $2D, $2D, $2D, $2D, $2D, $2D, $2B, $0D, $00, $21, $20, $20
	.BYTE $20, $20, $20, $4D, $49, $43, $52, $4F, $43, $48, $45, $53, $53, $20, $20, $20
	.BYTE $20, $20, $21, $0D, $00, $21, $20, $28, $43, $29, $20, $50, $45, $54, $45, $52
	.BYTE $20, $4A, $45, $4E, $4E, $49, $4E, $47, $53, $20, $21, $0D, $00, $21, $20, $20
	.BYTE $50, $45, $54, $45, $52, $4A, $40, $42, $45, $4E, $4C, $4F, $2E, $43, $4F, $4D
	.BYTE $20, $20, $21, $0D, $00, $2B, $2D, $2D, $2D, $2D, $2D, $2D, $2D, $2D, $2D, $2D
	.BYTE $2D, $2D, $2D, $2D, $2D, $2D, $2D, $2D, $2D, $2D, $2B, $0D, $FF, $4B, $51, $52
	.BYTE $52, $42, $42, $4E, $4E, $50, $50, $50, $50, $50, $50, $50, $50, $03, $04, $00
	.BYTE $07, $02, $05, $01, $06, $10, $17, $11, $16, $12, $15, $14, $13, $73, $74, $70
	.BYTE $77, $72, $75, $71, $76, $60, $67, $61, $66, $62, $65, $64, $63, $00, $F0, $FF
	.BYTE $01, $10, $11, $0F, $EF, $F1, $DF, $E1, $EE, $F2, $12, $0E, $1F, $21, $0B, $0A
	.BYTE $06, $06, $04, $04, $04, $04, $02, $02, $02, $02, $02, $02, $02, $02, $A9, $20
	.BYTE $4C, $EF, $FF, $A9, $0D, $4C, $EF, $FF, $AD, $11, $D0, $10, $FB, $AD, $10, $D0
	.BYTE $29, $7F, $60
CA
	.BYTE $20, $F1, $03, $20, $1B, $05, $20, $57, $03, $20, $AD, $03, $A9, $00, $85, $1C
	.BYTE $A0, $29, $A5, $1E, $F0, $01, $C8, $A5, $14, $4A, $08, $4A, $26, $1C, $28, $26
	.BYTE $1C, $A5, $10, $2A, $20, $6F, $03, $26, $1C, $8A, $48, $98, $48, $20, $7A, $03
	.BYTE $68, $A8, $68, $AA, $26, $19, $26, $18, $26, $17, $26, $16, $26, $15, $88, $D0
	.BYTE $E3, $AD, $11, $D0, $10, $C0, $AD, $10, $D0, $29, $7F, $20, $20, $05, $C9, $4D
	.BYTE $F0, $AE, $C9, $1B, $D0, $B0, $60, $20, $AD, $03, $A0, $28, $20, $6F, $03, $B0
	.BYTE $05, $20, $16, $05, $90, $05, $A9, $2A, $20, $EF, $FF, $88, $D0, $EE, $60, $26
	.BYTE $14, $26, $13, $26, $12, $26, $11, $26, $10, $60, $A5, $1C, $A4, $1E, $F0, $15
	.BYTE $29, $1F, $A2, $00, $A0, $05, $4A, $90, $01, $E8, $88, $D0, $F9, $A0, $01, $84
	.BYTE $1B, $8A, $38, $B0, $07, $29, $07, $A2, $01, $86, $1B, $AA, $F0, $05, $06, $1B
	.BYTE $CA, $D0, $FB, $A5, $1A, $25, $1B, $D0, $02, $18, $60, $38, $60, $A2, $05, $B5
	.BYTE $14, $95, $0F, $CA, $D0, $F9, $60, $20, $3F, $45, $4C, $55, $52, $20, $3F, $53
	.BYTE $55, $49, $44, $41, $52, $49, $4E, $49, $54, $49, $41, $4C, $20, $53, $54, $41
	.BYTE $54, $45, $3A, $00, $31, $2E, $20, $44, $4F, $54, $00, $32, $2E, $20, $52, $41
	.BYTE $4E, $44, $4F, $4D, $00, $33, $2E, $20, $45, $4E, $54, $45, $52, $00, $3E, $20
	.BYTE $FF, $20, $3C, $04, $20, $20, $05, $20, $EF, $FF, $C9, $1B, $F0, $3B, $38, $E9
	.BYTE $30, $C9, $04, $B0, $31, $AA, $F0, $2E, $20, $1B, $05, $CA, $D0, $10, $A9, $00
	.BYTE $85, $15, $85, $16, $85, $18, $85, $19, $A9, $10, $85, $17, $D0, $55, $CA, $D0
	.BYTE $12, $A2, $05, $20, $DB, $04, $95, $14, $20, $DB, $04, $20, $DB, $04, $CA, $D0
	.BYTE $F2, $F0, $40, $4C, $58, $04, $4C, $00, $03, $68, $68, $60, $20, $1B, $05, $A2
	.BYTE $FF, $E8, $BD, $C5, $03, $D0, $06, $20, $1B, $05, $4C, $41, $04, $C9, $FF, $F0
	.BYTE $06, $20, $EF, $FF, $4C, $41, $04, $60, $A9, $3F, $20, $EF, $FF, $20, $16, $05
	.BYTE $A0, $00, $20, $A9, $04, $99, $15, $00, $20, $16, $05, $C8, $C0, $05, $D0, $F2
	.BYTE $20, $1B, $05, $A2, $08, $BD, $BC, $03, $20, $EF, $FF, $CA, $D0, $F7, $20, $20
	.BYTE $05, $20, $EF, $FF, $C9, $1B, $F0, $B1, $C9, $31, $F0, $04, $C9, $32, $D0, $E0
	.BYTE $38, $E9, $31, $85, $1E, $20, $1B, $05, $A2, $06, $BD, $B6, $03, $20, $EF, $FF
	.BYTE $CA, $D0, $F7, $20, $A9, $04, $85, $1A, $60, $A2, $00, $20, $CD, $04, $85, $11
	.BYTE $20, $04, $05, $C9, $FF, $F0, $F4, $20, $E5, $FF, $20, $CD, $04, $85, $12, $20
	.BYTE $04, $05, $C9, $FF, $F0, $F4, $20, $E5, $FF, $20, $E5, $04, $60, $20, $20, $05
	.BYTE $C9, $1B, $D0, $06, $68, $68, $68, $68, $68, $68, $60, $A5, $1D, $0A, $90, $02
	.BYTE $49, $CF, $85, $1D, $60, $20, $02, $05, $C9, $FF, $F0, $27, $48, $20, $01, $05
	.BYTE $CA, $C9, $FF, $D0, $02, $68, $60, $85, $10, $68, $0A, $0A, $0A, $0A, $65, $10
	.BYTE $60, $E8, $B5, $11, $49, $30, $C9, $0A, $90, $08, $69, $88, $C9, $FA, $90, $03
	.BYTE $29, $0F, $60, $A9, $FF, $60, $A9, $20, $4C, $EF, $FF, $A9, $0D, $4C, $EF, $FF
	.BYTE $E6, $1D, $AD, $11, $D0, $10, $F9, $AD, $10, $D0, $29, $7F, $60
END

MMSZ = LMM-MM
LMMSZ = HG-LMM
HGSZ = NIM-HG
NIMSZ = PAS-NIM
PASSZ = MCHESS-PAS
CHSZ = CA-MCHESS
CASZ = END-CA

; tables
SRCL
	.byte <MM
	.byte <LMM
	.byte <HG
	.byte <NIM
	.byte <PAS
	.byte <MCHESS
	.byte <CA
SRCH
	.byte >MM
	.byte >LMM
	.byte >HG
	.byte >NIM
	.byte >PAS
	.byte >MCHESS
	.byte >CA
SZL
	.byte <MMSZ
	.byte <LMMSZ
	.byte <HGSZ
	.byte <NIMSZ
	.byte <PASSZ
	.byte <CHSZ
	.byte <CASZ
SZH
	.byte >MMSZ
	.byte >LMMSZ
	.byte >HGSZ
	.byte >NIMSZ
	.byte >PASSZ
	.byte >CHSZ
	.byte >CASZ
	
	.if APPLE1
; Apple 1 I/O values
OUTCH	=$FFEF		; Apple 1 Echo
PRHEX	=$FFE5		; Apple 1 Echo
OUTHEX	=$FFDC		; Apple 1 Print Hex Byte Routine
KBD     =$D010		; Apple 1 Keyboard character read.
KBDRDY  =$D011		; Apple 1 Keyboard data waiting when negative.
	.else
IOMEM	=$E000
PUTCH	=IOMEM+1
KBD	=IOMEM+4
KBDRDY  =IOMEM+4

	.ORG $FB82
MOVE			; Move memory down
	LDY #$00
	LDX SIZEH
	BEQ .MD2
.MD1	LDA (FROM),Y ; move a page at a time
	STA (TO),Y
	INY
	BNE .MD1
	INC FROM+1
	INC TO+1
	DEX
	BNE .MD1
.MD2	LDX SIZEL
	BEQ .MD4
.MD3	LDA (FROM),Y ; move the remaining bytes
	STA (TO),Y
	INY
	DEX
	BNE .MD3
.MD4	RTS

	.ORG $FFDC
OUTHEX	PHA 		; Print 1 hex byte. 
	LSR
	LSR 
	LSR
	LSR 
	JSR PRHEX
	PLA 
PRHEX	AND #$0F	; Print 1 hex digit
	ORA #$30
	CMP #$3A
	BCC OUTCH
	ADC #$06
OUTCH	STA PUTCH
	RTS  
	.endif